<?php
include 'telegram.php'; 
// Read the raw POST data from the webhook payload
$jsonPayload = file_get_contents('php://input');
// Decode the JSON payload
$data = json_decode($jsonPayload, true);



// Extract necessary information
$productTitle = $data['title'];
$productType = $data['product_type'];
$vendor = $data['vendor'];
$tags = $data['tags'];
$image= $data['images'][0]['src'];

// Prepare a detailed message for all variants
$variantDetails = array();
foreach ($data['variants'] as $variant) {
    $variantDetails[] = $variant['title'] . " priced at QAR " . $variant['price'];
}
$variantText = implode(", ", $variantDetails);

// Format the message
$text =  urlencode("Product Updated: $productTitle ($productType) by $vendor. Variants: $variantText" ) ;



//telegram

 
sendTelegram($text,$image);
 


?>