<?php
include 'telegram.php'; 
include 'wa.php'; 

// Read the raw POST data from the webhook payload
$jsonPayload = file_get_contents('php://input');

// Decode the JSON payload
$data = json_decode($jsonPayload, true);

// Extract necessary information
$orderNumber = $data['name'] ?? 'Unknown';  // Order name (e.g., #9999)
$orderStatus = $data['fulfillment_status'] ?? 'Pending'; // Fulfillment status
$customerName = ($data['customer']['first_name'] ?? '') . ' ' . ($data['customer']['last_name'] ?? '');
$totalAmount = $data['total_price'] ?? '0.00';
$currency = $data['currency'] ?? 'QAR'; 

// Extract customer phone number
$customerPhone = $data['customer']['phone'] ?? ($data['billing_address']['phone'] ?? 'Not Provided');

// Ensure correct Telegram message formatting
$telegramText = "📦 *Order Update* \n" .
    "-----------------------------\n" .
    "🆔 *Order #:* $orderNumber \n" .
    "👤 *Customer:* $customerName \n" .
    "📞 *Phone:* $customerPhone \n" .
    "💰 *Amount:* $currency $totalAmount \n" .
    "📌 *Status:* $orderStatus \n" .
    "-----------------------------\n" .
    "✅ Thank you for your order!";

// Send Telegram Notification
sendTelegram($telegramText);

// Format the message for WhatsApp
$whatsappText = "Dear $customerName,\n\nYour order #$orderNumber is now updated to status: *$orderStatus*.\nTotal Amount: $currency $totalAmount\n\nThank you for shopping with us!";

// Send WhatsApp Message
if ($customerPhone !== 'Not Provided') {
    sendWhatsAppMessage(+917907806606, $whatsappText);
} else {
    sendWhatsAppMessage('+917907806606', "⚠️ Failed to send update for Order #$orderNumber as customer phone is missing.");
}

?>