<?php
 

// Read the raw POST data from the webhook payload
$webhookPayload = file_get_contents('php://input');

// Decode the JSON payload to an array
$events = json_decode($webhookPayload, true);

// Extract the contact ID from the first event (assuming there's only one event in the payload)
$contactId = $events[0]['objectId'];
$action=$events[0]['subscriptionType'];

// The API endpoint
$apiUrl = 'https://api.hubapi.com/crm/v3/objects/contacts/' . $contactId ;

// The bearer token
$bearerToken = 'pat-na1-4f84357e-168f-4e3a-9ad1-718718e3b8dc';

// Initialize cURL session
$ch = curl_init($apiUrl);

// Set the cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $bearerToken,
    'Content-Type: application/json'
]);

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo 'cURL error: ' . curl_error($ch);
} else {
    // Process the response
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($httpCode == 200) {
        // Successfully received response
        $data = json_decode($response, true);

        // Extract contact details
        $firstName = isset($data['properties']['firstname']) ? $data['properties']['firstname'] : 'N/A';
        $lastName = isset($data['properties']['lastname']) ? $data['properties']['lastname'] : 'N/A';
        $phone = isset($data['properties']['phone']) ? $data['properties']['phone'] : 'N/A';
        $email = isset($data['properties']['email']) ? $data['properties']['email'] : 'N/A';

        // Create a human-readable string
        $contactInfo = "\n";
        $contactInfo .= "Name: $firstName \n";
        $contactInfo .= "Email: $email\n";

     
    } else {
        // Handle different HTTP response codes
        echo 'HTTP error code: ' . $httpCode;
    }
}

// Close cURL session
curl_close($ch);
 



$url = 'https://api.telegram.org/bot6178141828:AAFTPAWUHXVn04bfcNyD-r4DhXuQ1PFkBPY/sendMessage?chat_id=-1001463428360&parse_mode=HTML&text=HubSpot-' . $action . '-' . urlencode($contactInfo) ;
$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
if ($response === false) {
    echo 'Curl error: ' . curl_error($ch);
} else {
    echo 'Response: ' . $response;
}
curl_close($ch);


//Log POST DATA
file_put_contents('log.txt', $url  . PHP_EOL, FILE_APPEND);

?>