<?php
include 'telegram.php'; 
// Read the raw POST data from the webhook payload
$jsonPayload = file_get_contents('php://input');

// Decode the JSON payload
$data = json_decode($jsonPayload, true);

// Extract necessary information
$orderNumber = $data['name'];  // Order name which is typically shown as #9999 in Shopify
$customerName = $data['customer']['first_name'] . ' ' . $data['customer']['last_name'];  // Concatenate first name and last name
$totalAmount = $data['total_price'];
$currency = 'QAR';  // Set the currency if not dynamically available in the payload

// Format the message
$text =  "New #Order Received. Order#: $orderNumber, Customer: $customerName, Amount: $currency $totalAmount" ;

//telegram
sendTelegram($text,'https://wh.intertoons.in/lc/neworder.png');

?>