<?php
   
     // Capture raw POST data
    $rawPostData = file_get_contents('php://input');

    // Decode the JSON data into an associative array
    $data = json_decode($rawPostData, true);

    // Check if JSON decoding was successful
    if (json_last_error() !== JSON_ERROR_NONE) {
        return "Error decoding JSON data: " . json_last_error_msg();
    }

    // Extract specific fields
    $packageName = isset($data['data']['package']['name']) ? $data['data']['package']['name'] : 'Unknown Package Name';
    $amount = isset($data['data']['purchase']['price']['final']) ? $data['data']['purchase']['price']['final'] : 'Unknown Amount';
    $customerId = isset($data['data']['guest_id']) ? $data['data']['guest_id'] : 'Unknown Customer ID';
    $contactNumber = isset($data['data']['guest']['mobile_phone']) ? $data['data']['guest']['mobile_phone'] : 'Unknown Contact Number';
    
    $guestFirstName = isset($data['data']['guest']['first_name']) ? $data['data']['guest']['first_name'] : 'Unknown First Name';
    $guestLastName = isset($data['data']['guest']['last_name']) ? $data['data']['guest']['last_name'] : 'Unknown Last Name';
    $guestFullName = $guestFirstName . ' ' . $guestLastName;

    // Extract services details
    $services = [];
    if (isset($data['data']['services']) && is_array($data['data']['services'])) {
        foreach ($data['data']['services'] as $service) {
            $serviceName = isset($service['service_type_info']['name']) ? $service['service_type_info']['name'] : 'Unknown Service Name';
            $serviceDuration = isset($service['service_type_info']['duration']) ? $service['service_type_info']['duration'] : 'Unknown Duration';
            $serviceSessions = isset($service['total']) ? $service['total'] : 'Unknown Number of Sessions';
            $services[] = "Service: $serviceName, Duration: $serviceDuration mins, Sessions: $serviceSessions";
        }
    }

    // Combine the extracted values into a single string
    $formattedString = "Customer ID: $customerId
Name: $guestFullName
Contact Number: $contactNumber
Package Name: $packageName
Amount: $amount
Services:
" . implode("\n", $services);



$url = 'https://api.telegram.org/bot7102944006:AAH4TrmALb3HPfW0Bct-rL476K4MgzCgW0Y/sendMessage?chat_id=-1002129322639&parse_mode=HTML&text=PackageCreated-' . urlencode($formattedString) ;
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
if ($response === false) {
    echo 'Curl error: ' . curl_error($ch);
} else {
    echo 'Response: ' . $response;
}
curl_close($ch);

//Log POST DATA
///file_put_contents('log.txt', json_encode($data) . PHP_EOL, FILE_APPEND);

?>